import "./MainCard.css";


const FiberPlanMain = ({
  handleCallbackButtonClick,
  handleDisplayFiberPlans,
  homeElement,
  inputElement,
}) => {
  return (
    <div className="elife_container">
      <div className="elife_main_container fiber">
        <section className="main_offer-section">
          <div className="offer_title" ref={homeElement}>
            <h1 ref={inputElement}>
              AED <span>389</span>272
            </h1>
            <span className="month">/month + 5% VAT</span>
          </div>
          <div className="offer_percentage">
            <p>
              24 months contract + <span>fees & charges</span>
            </p>
          </div>
          <div className="offer_duration">
            <p>30% off for 6 months</p>
          </div>
        </section>

        <section className="plan_section">
          <p>You get</p>
          <h2>du Home Starter</h2>
        </section>

        <section className="speed_section">
          <h2 className="mbps_offer">
            <span className="old_price">250</span>
            500 Mbps <span className="download">Download</span>
          </h2>
          <p>
            Advanced<span className="wifi_standard">WiFi router</span>
          </p>
        </section>
        <hr />
        <section className="extra_offers_section">
          <div className="extra_offer">
            <div className="each_offer">
              <p>
                Essential Pack - 1 pack of your <br /> choice
              </p>
              <img src="/images/du-tv-package.svg" alt="dutv" />
            </div>
          </div>
        </section>
        <hr />
        <section className="yearly_offers_section">
          <div className="twelve_month">12 months on us</div>
          <div className="yearly_offer">
            <p>Disney +</p>
            <img src="/images/disneyplus.png" alt="disney+" />
          </div>
          <div className="yearly_offer">
            <p>OSN +</p>
            <span>Online exclusive</span>
            <img src="/images/osn-streaming-app.png" alt="osn+" />
          </div>
          <div className="yearly_offer">
            <p>1 HDTV receiver</p>
          </div>
        </section>
        <hr />
        <div className="utility-btns">
          <button className="buy_now" onClick={handleCallbackButtonClick}>
            BUY NOW
          </button>
          <button className="see_more" onClick={handleDisplayFiberPlans}>
            SEE MORE
          </button>
        </div>
      </div>
    </div>
  );
};

export default FiberPlanMain;
