
'use client'
import '../app/styles.css'
import 'bootstrap/dist/css/bootstrap.min.css';
import { useRef, useState } from "react";
import Navbar from "@/components/Navbar/Navbar";
import Banner from "@/components/Banner/Banner";
import DuHomeLightMain from "@/components/Cards/DuHomeLightMain";
import FiberPlanMain from "@/components/Cards/FiberPlanMain";
import FiberPlans from "@/pages/FiberPlans/FiberPlans";
import DuHomeLight from "@/pages/DuHomeLight/DuHomeLight";
import Contact from "@/components/Contact/Contact";
import Footer from "@/pages/Footer";
import Head from 'next/head';


function Home() {
  const [showFiberPlan, setShowFiberPlan] = useState(true);
  const [showDuHomeLightPlan, setShowDuHomeLightPlan] = useState(false);

  const inputElement = useRef();
  const homeElement = useRef();
  const submitButtonRef = useRef();
  const contactElement = useRef();

  const handleCallbackButtonClick = () => {
    if (submitButtonRef.current) {
      window.scrollTo({
        top: submitButtonRef.current.offsetTop,
        behavior: "smooth",
      });
    }
  };
  const handleDisplayMoreOffers = () => {
    inputElement.current.scrollIntoView({ behavior: "smooth" });
  };

  const handleDisplayDuHomeLightPlans = () => {
    setShowFiberPlan(false);
    setShowDuHomeLightPlan(true);
    handleDisplayMoreOffers();
  };

  const handleDisplayFiberPlans = () => {
    setShowDuHomeLightPlan(false);
    setShowFiberPlan(true);
    handleDisplayMoreOffers();
  };

  return (
    <>
     
      <section>
        <Navbar
          showFiberPlan={showFiberPlan}
          setShowFiberPlan={setShowFiberPlan}
          handleCallbackButtonClick={handleCallbackButtonClick}
          scrollSliderContainerIntoView={() =>
            inputElement.current.scrollIntoView({ behavior: "smooth" })
          }
          scrollHomeContainerIntoView={() =>
            homeElement.current.scrollIntoView({ behavior: "smooth" })
          }
          scrollHomeContactIntoView={() =>
            contactElement.current.scrollIntoView({ behavior: "smooth" })
          }
        />
        <Banner handleCallbackButtonClick={handleCallbackButtonClick} />
      </section>
      <section className="main_cards-container">
        <div className="main_cards">
          <div className="main_card">
            <h3>1 Year Contract</h3>
            <DuHomeLightMain
              handleCallbackButtonClick={handleCallbackButtonClick}
              handleDisplayDuHomeLightPlans={handleDisplayDuHomeLightPlans}
            />
          </div>
          <div className="main_card">
            <h3>2 Years Contract</h3>
            <FiberPlanMain
              handleCallbackButtonClick={handleCallbackButtonClick}
              handleDisplayFiberPlans={handleDisplayFiberPlans}
              homeElement={homeElement}
            />
          </div>
        </div>
      </section>
      <section>
        {showFiberPlan && (
          <FiberPlans
            handleCallbackButtonClick={handleCallbackButtonClick}
            inputElement={inputElement}
          />
        )}
        {showDuHomeLightPlan && (
          <DuHomeLight
            handleCallbackButtonClick={handleCallbackButtonClick}
            inputElement={inputElement}
          />
        )}
      </section>
      <section>
        <Contact
          submitButtonRef={submitButtonRef}
          contactElement={contactElement}
        />

        <Footer />
      </section>
    </>
  );
}

export default Home;
