import React, { useEffect } from "react";

function ScrollOnSpacebar() {
  useEffect(() => {
    function handleKeyPress(event) {
      if (event.key === " " || event.key === "Spacebar") {
        event.preventDefault();
        window.scrollBy(0, window.innerHeight);
        const sections = document.querySelectorAll(".section");
        let middleSection = null;
        sections.forEach(function (section) {
          const rect = section.getBoundingClientRect();
          if (
            rect.top <= window.innerHeight / 3 &&
            rect.bottom >= window.innerHeight / 3
          ) {
            middleSection = section;
          }
        });
        if (middleSection) {
          const rect = middleSection.getBoundingClientRect();
          window.scrollTo({
            top:
              rect.top +
              window.scrollY -
              (window.innerHeight - rect.height) / 2.3,
            behavior: "smooth",
          });
        }
      }
    }

    window.addEventListener("keydown", handleKeyPress);

    return () => {
      window.removeEventListener("keydown", handleKeyPress);
    };
  }, []);

  return null;
}

export default ScrollOnSpacebar;
